;Free Agent Scripts
;Copyright 1999,  by Henter-Joyce, In. 
;Created 4/99 by DaveB

include "hjconst.jsh"
include "hjglobal.jsh"
include "agent.jsh"
include "agent.jsm"

globals
	int IgnoreNewText,
	int AgentFirstTime,
	string sLine ; for the list browser windows 

String Function WhichList ()
var
	handle hWnd,
	string sClass, ;current class
	string sNextClass, ; class of hWnd
	string sPrevClass
let hWnd = GetNextWindow (GetFocus ())
let sNextClass = GetWindowClass (hWnd)
let sPrevClass = GetWindowClass (GetPriorWindow (GetFocus ()))
let sClass = GetWindowClass (GetFocus ())
if ((hWnd) && (sNextClass == wcHeader) && StringContains (GetWindowText (hWnd, false), msg12)) then
	Return (msg2); "messages"
EndIf
Return (msg1); "news groups"
EndFunction

Void Function AutoStartEvent ()
if AgentFirstTime == 0 then
	let AgentFirstTime = 1
	Say (msg45 + GetScriptKeyName ("HotKeyHelp"), OT_MESSAGE); "For a list of Jaws hot keys press"
	Say (msg44 + GetScriptKeyName ("WindowKeysHelp"), OT_MESSAGE); "For a list of windows shortcut keys press"
	Say (msg46 + GetScriptKeyName ("ScreenSensitiveHelp"), OT_MESSAGE); "For screen sensitive help press"
EndIf
EndFunction

Void Function FocusChangedEvent (handle FocusWindow, handle prevWindow)
var
	handle hWnd,
	handle AppWindow,
	string sClass, ;current class
	string sNextClass, ; class of hWnd
	string sPrevClass, 
	string sBuffer 
let hWnd = GetNextWindow (focusWindow)
let AppWindow = GetAppMainWindow (focusWindow)
let sNextClass = GetWindowClass (hWnd)
let sPrevClass = GetWindowClass (GetPriorWindow (focusWindow))
let sClass = GetWindowClass (focusWindow)
let sBuffer = GetWindowText (focusWindow, false)
PcCursor ()
If ((GetWindowClass (GetRealWindow (FocusWindow)) == wcDialog) && (GetWindowName (GetRealWindow (FocusWindow)) == msg48)) then
	If (GetRealWindow (FocusWindow) != GlobalPrevReal) then
		Say (msg49, OT_HELP); "This is the Window Layout dialog"
	Say (msg50, OT_HELP); "It contains graphical content depicting the various layout posibilities for panes and list boxes"
	Say (msg51, OT_HELP); "whereas we recommend you use the default layout with Jaws for Windows, your layout can be changed with sighted assistance in this dialog"
EndIf
EndIf
if (sClass == wcListBrowser) then
	Say (WhichList (), OT_CONTROL_NAME)
EndIf; for the list browsers
If (sClass == wcViewer) then
	If (sPrevClass == wcStatic) then
		Say (msg8, OT_CONTROL_NAME); "edit"
		Return
	EndIf
	Say (msg3, OT_CONTROL_NAME); "Message Viewer"
	SayNonHighlightedText (FocusWindow, sBuffer)
	Return;
EndIf
FocusChangedEvent (focusWindow, prevWindow)
EndFunction

Void Function SayFocusedWindow ()
var
	handle hWnd,
	handle hPWnd,
	string sClass,
	string sPrevClass
let hWnd = GetCurrentWindow ()
let sClass = GetWindowClass (hWnd)
if (sClass == wcListBrowser) then
EndIf
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Void Function SayNonHighlightedText (handle hWnd, string buffer)
var
	string sClass
let sClass = GetWindowClass (hWnd)
if (sClass == wcListBrowser) then
	Return;
EndIf
if (sClass == wcViewer) then
	if (GetWindowClass (GetFocus ()) == wcListBrowser) then return EndIf
	If IgnoreNewText then Return EndIf
	If (GetWindowClass (GetPriorWindow (GetFocus ())) == wcStatic) then return endif
	If (GetWindowText (hWnd, false) == "") then
		Say (msg7, OT_BUFFER); "No Text"
		Return;
	EndIf
	Say (buffer, OT_BUFFER)
EndIf
SayNonHighlightedText (hWnd, buffer)
EndFunction

Void Function SayHighlightedText (handle hWnd, string buffer)
var
	string sClass
let sClass = GetWindowClass (hWnd)
if (sClass == wcListBrowser) then
	Return;
EndIf
SayHighlightedText (hWnd, buffer)
EndFunction



Script ScriptFileName ()
ScriptAndAppNames ("Free Agent")
EndScript

Script SayPriorLine ()
var
	handle hWnd,
	string sClass,
	string sCurrentLine
let hWnd = GetFocus ()
let sClass = GetWindowClass (hWnd)
if ((sClass == wcListBrowser) && (IsPcCursor ()) && (not GlobalMenuMode)) then
	;let sLine = GetLine ()
	PriorLine ()
	; Code removed here because list boxes properly announce themselves
	let sCurrentLine = GetLine ()
	;If (StringContains (sCurrentLine, sLine)) then
		;Say (msg4, OT_MESSAGE); "bottom of list"
	;EndIf
	SayLine ()
	Return
EndIf
PerformScript SayPriorLine ()
EndScript

Script SayNextLine ()
var
	handle hWnd,
	string sClass,
	string sCurrentLine
let hWnd = GetFocus ()
let sClass = GetWindowClass (hWnd)
if ((sClass == wcListBrowser) && (IsPcCursor ()) && (not GlobalMenuMode)) then
	;let sLine = GetLine ()
	NextLine ()
	; Code removed here because list boxes properly announce themselves
	let sCurrentLine = GetLine ()
	;If (StringContains (sCurrentLine, sLine)) then
		;Say (msg4, OT_MESSAGE); "bottom of list"
	;EndIf
	SayLine ()
	Return
EndIf
PerformScript SayNextLine ()
EndScript

Script JawsHome ()
var
	handle hWnd,
	string sClass
let hWnd = GetFocus ()
let sClass = GetWindowClass (hWnd)
if ((IsPcCursor ()) && (sClass == wcListBrowser)) then
	{home}
	Pause ()
	Say (msg57, OT_MESSAGE); "home"
	SayLine ()
	Return
EndIf
PerformScript JawsHome ()
EndScript

Script JawsEnd ()
var
	handle hWnd,
	string sClass
let hWnd = GetFocus ()
let sClass = GetWindowClass (hWnd)
if ((IsPcCursor ()) && (sClass == wcListBrowser)) then
	{end}
	Pause ()
	Say (msg58, OT_MESSAGE); "end"
	SayLine ()
	Return
EndIf
PerformScript JawsEnd ()
EndScript

Script ReadCurrentScreen ()
var
	handle hWnd,
	string sClass
let hWnd = GetCurrentWindow ()
let sClass = GetWindowClass (hWnd)
If (sClass == wcViewer) then
	If (GetWindowText (hWnd, false) == "") then
		PCCursor ()
		Say (msg7, OT_MESSAGE); "No Text"
		Return;
	EndIf
	JawsCursor ()
	MoveToWindow (hWnd)
	SayAll ()
Else
	PcCursor ()
	Say (msg6, OT_MESSAGE); "Not in mesage viewer"
EndIf
EndScript

Script ReadNextScreen ()
var
	handle hWnd,
	string sClass
let hWnd = GetCurrentWindow ()
let sClass = GetWindowClass (hWnd)
If (sClass == wcViewer) then
	let IgnoreNewText = true
	PcCursor ()
	{PageDown}
	Pause ()
	PerformScript ReadCurrentScreen ()
	let IgnoreNewText = false
Else
	Say (msg6, OT_MESSAGE); "Not in mesage viewer"
EndIf
EndScript

Script ReadPriorScreen ()
var
	handle hWnd,
	string sClass
let hWnd = GetCurrentWindow ()
let sClass = GetWindowClass (hWnd)
If (sClass == wcViewer) then
	let IgnoreNewText = true
	PcCursor ()
	{PageUp}
	Pause ()
	PerformScript ReadCurrentScreen ()
	let IgnoreNewText = false
Else
	Say (msg6, OT_MESSAGE); "Not in mesage viewer"
EndIf
EndScript

Script JawsPageUp ()
let IgnoreNewText = false
PerformScript JawsPageUp ()
EndScript

Script JawsPageDown ()
let IgnoreNewText = false
PerformScript JawsPageDown ()
EndScript

Script SayWindowPromptAndText ()
var
	handle hWnd,
	handle hPrev,
	string sClass,
	string sPrevClass
let hWnd = GetCurrentWindow ()
let hPrev = GetPriorWindow (hWnd)
let sClass = GetWindowClass (hWnd)
let sPrevClass = GetWindowClass (hPrev)
; for the Message viewing window
if (sClass == wcViewer) then 
	If (sPrevClass == wcStatic) then
		Say (msg8, OT_CONTROL_NAME); "edit"
		Return
	EndIf
	Say (msg3, OT_CONTROL_NAME); "message viewer"
	Return
EndIf
; for the different List Browser windows
If (sClass == wcListBrowser) then
	Say (WhichList (), OT_CONTROL_NAME)
EndIf
PerformScript SayWindowPromptAndText ()
EndScript

Script GoToAttachments ()
var
	handle hWnd,
	string sClass
let sClass = GetWindowClass (GetFocus ())
	SaveCursor ()
	JawsCursor ()
	let hWnd = FindDescendantWindow (GetParent (GetFocus ()), iD_Attach)
	if ((hWnd) && (IsWindowVisible (hWnd))) then
		MoveToWindow (hWnd)
		LeftMouseButton ()
	Else
		RestoreCursor ()
		Say (msg10, OT_MESSAGE); "attach button not found"
	EndIf
EndScript

Script ScreenSensitiveHelp ()
var
	handle hWnd,
	string sClass,
	string sPrevClass
let hWnd = GetPriorWindow (GetCurrentWindow ())
let sClass = GetWindowClass (GetCurrentWindow ())
let sPrevClass = GetWindowClass (hWnd)
; for the Window Layout dialog
If ((GetWindowClass (GetRealWindow (GetFocus ())) == wcDialog) && (GetWindowName (GetRealWindow (GetCurrentWindow ())) == msg48)) then ; "Window Layout
		Say (msg49, OT_HELP); "This is the Window Layout dialog"
	Say (msg50, OT_HELP); "It contains graphical content depicting the various layout posibilities for panes and list boxes"
	Say (msg51, OT_HELP); "whereas we recommend you use the default layout with Jaws for Windows, your layout can be changed with sighted assistance in this dialog"
	Return
EndIf
; For the Color combo boxes
If (GetWindowName (GetRealWindow (GetFocus ())) == msg56) && (sClass == wcComboBox) then
	Say (msg52, OT_HELP); "This is one of a series of color combo boxes"
	Say (msg53, OT_HELP); "These boxes do not have text in them"
	Say (msg54, OT_HELP); "We recommend you leave the colors at their defaults when using Jaws for Windows"
	Say (msg55, OT_HELP); "However, with sighted assistance, you can change the colors for various aspects of the Free Agent program"
	return
EndIf
; for the list browsers
if (sClass == wcListBrowser) then
Say (msg13, OT_HELP); "This is the list of available"
	Say (WhichList (), OT_HELP)
EndIf
;for the Message Viewer and main message body window
If (sClass == wcViewer) then
	If sPrevClass == wcStatic then
		Say (msg14, OT_HELP); "This is the message edit window"
		Say (msg37, OT_HELP); "The Windows shortcut keys will take you directly to the fields"
		Say (msg39, OT_HELP); "After pressing a shortCut key"
		Say (msg38, OT_HELP); "Press tab and shift + tab to navigate the dialog"
		Say (msg15, OT_HELP); "Press insert + w for a list of hot keys for this window"
		Return
	EndIf
Say (msg16, OT_HELP); "This is the message viewer"
	Say (msg17, OT_HELP); "Navigate it as you would any help window"
	Say (msg18 + GetScriptKeyName ("ReadCurrentScreen"), OT_HELP)
	Say (msg19 + GetScriptKeyName ("ReadNextScreen"), OT_HELP)
	Say (msg20 + GetScriptKeyName ("ReadPriorScreen"), OT_HELP)
	Return
EndIf
PerformScript ScreenSensitiveHelp ()
EndScript

Script WindowKeysHelp ()
var
	string sClass,
	string sPrevClass
let sClass = GetWindowClass (GetFocus ())
let sPrevClass = GetWindowClass (GetPriorWindow (GetFocus ()))
If (sClass == wcListBrowser) then
	If (WhichList () == msg1) then
		Say (msg24, OT_HELP); "To view a list of messages within the selected group, press enter"
		Say (msg21, OT_HELP); "To go online, press control + o"
		Say (msg22, OT_HELP); "To post a new UseNet message, press p"
		Say (msg23, OT_HELP); "To compose an e-mail message, press control + m"
		Say (msg25, OT_HELP); "To view the properties for the selected group, press alt + enter"
		Say (msg26, OT_HELP); "to show only subscribed groups, press control + s"
		Return;
	ElIf (WhichList () == msg2) then
		Say (msg29, OT_HELP); "To view the selected message, press enter"
		Say (msg21, OT_HELP); "To go online, press control + o"
		Say (msg22, OT_HELP); "To post a new UseNet message, press p"
		Say (msg27, OT_HELP); "To follow up UseNet message, press f"
		Say (msg23, OT_HELP); "To compose an e-mail message, press control + m"
		Say (msg28, OT_HELP); "To reply via E-Mail, press r"
		Say (msg41, OT_HELP); "To return to the list of newsgroups, press escape"
		Say (msg30, OT_HELP); "To bring up the Decode Binary Attachments dialog, press control + d"
		Return
	EndIf
EndIf
If (sClass == wcViewer) then
	; for composition windows
	If (sPrevClass == wcStatic) then
		Say (msg31, OT_HELP); "To send your message, press alt + s"
		Say (msg32, OT_HELP); "To send it later, press alt + l"
		Say (msg33, OT_HELP); "To save your message, press alt + v"
		Say (msg34, OT_HELP); "To move to the To field, press alt + t"
		Say (msg35, OT_HELP); "To go to the cc field, press alt + c"
		Say (msg36, OT_HELP); "To go to the subject field, press alt + b"
		Return
	Else
		Say (msg21, OT_HELP); "To go online, press control + o"
		Say (msg22, OT_HELP); "To post a new UseNet message, press p"
		Say (msg27, OT_HELP); "To follow up UseNet message, press f"
		Say (msg23, OT_HELP); "To compose an e-mail message, press control + m"
		Say (msg28, OT_HELP); "To reply via E-Mail, press r"
		Say (msg40, OT_HELP); "to return to the list of messages, press escape"
		Say (msg30, OT_HELP); "To bring up the Decode Binary Attachments dialog, press control + d"
		Return
	EndIf
EndIf
PerformScript WindowKeysHelp ()
EndScript

Script HotKeyHelp ()
var
	string sClass,
	string sPrevClass
let sClass = GetWindowClass (GetCurrentWindow ())
let sPrevClass = GetWindowClass (GetPriorWindow (GetCurrentWindow ()))
If (sClass == wcViewer) then
	If (sPrevClass == wcStatic) then
		Say ((msg43 + GetScriptKeyName ("GoToAttachments")), OT_HELP); "To click the attachment button, press"
		Say ((msg42 + GetScriptKeyName ("WindowKeysHelp")), OT_HELP); "For a list of shortcut keys when composing a message, press"
		Return
	Else
		Say (msg18 + GetScriptKeyName ("ReadCurrentScreen"), OT_HELP)
		Say (msg19 + GetScriptKeyName ("ReadNextScreen"), OT_HELP)
		Say (msg20 + GetScriptKeyName ("ReadPriorScreen"), OT_HELP)
		Say ((msg44 + GetScriptKeyName ("WindowKeysHelp")), OT_HELP); "For a list of windows shortcut keys press"
		Return
	EndIf
EndIf
PerformScript HotKeyHelp ()
EndScript
